<?php

namespace App\Filament\Resources\TransactionResource\Pages;

use App\Models\Setting;
use App\Models\Transaction;
use App\Services\DirectPrintService;
use App\Filament\Resources\TransactionResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewTransaction extends ViewRecord
{
    protected static string $resource = TransactionResource::class;

    protected static ?string $title = 'Detail Pesanan';

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('PrintBluetooth')
                ->label('Cetak Ulang')
                ->hidden(fn() => Setting::first()->value('print_via_bluetooth') == false)
                ->action(function () {
                    $order = Transaction::with(['paymentMethod', 'transactionItems.product'])->findOrFail($this->record->id);
                    $items = $order->transactionItems;

                    $this->printStruk($order, $items);
                })
                ->icon('heroicon-o-printer')
                ->color('amber'),
            Actions\Action::make('Print')
                ->label('Cetak Ulang')
                ->hidden(fn() => Setting::first()->value('print_via_bluetooth'))
                ->action(function () {
                    $directPrint = app(DirectPrintService::class);
                    $directPrint->print($this->record->id);
                })
                ->icon('heroicon-o-printer')
                ->color('amber'),
            Actions\EditAction::make(),
        ];
    }

    public function printStruk($order, $items)
    {
        $this->dispatch('doPrintReceipt',
            store: Setting::first(),
            order: $order,
            items: $items,
            date: $order->created_at->format('d-m-Y H:i:s')
        );
    }
}
