<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSayurBuahSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Pastikan ada kategori dulu
        $kategorySayur = \App\Models\Category::firstOrCreate(['name' => 'Sayuran']);
        $kategoriBuah = \App\Models\Category::firstOrCreate(['name' => 'Buah-buahan']);

        $products = [
            // SAYURAN (10 produk) - Alternating antara stok regular dan stok kongsi
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Bayam Segar',
                'stock' => 15.5,
                'stok_kongsi' => 0,
                'cost_price' => 8000,
                'price' => 12000,
                'price_per_kg' => 12000,
                'sku' => 'SYR001',
                'barcode' => '1001',
                'image' => 'products/default.webp',
                'description' => 'Bayam segar berkualitas premium',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Kangkung Organik',
                'stock' => 0,
                'stok_kongsi' => 8.75,
                'cost_price' => 6000,
                'price' => 10000,
                'price_per_kg' => 10000,
                'sku' => 'SYR002',
                'barcode' => '1002',
                'image' => 'products/default.webp',
                'description' => 'Kangkung organik tanpa pestisida',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Tomat Merah',
                'stock' => 25.75,
                'stok_kongsi' => 0,
                'cost_price' => 15000,
                'price' => 22000,
                'price_per_kg' => 22000,
                'sku' => 'SYR003',
                'barcode' => '1003',
                'image' => 'products/default.webp',
                'description' => 'Tomat merah segar untuk masakan',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Wortel Ungu',
                'stock' => 0,
                'stok_kongsi' => 7.5,
                'cost_price' => 12000,
                'price' => 18000,
                'price_per_kg' => 18000,
                'sku' => 'SYR004',
                'barcode' => '1004',
                'image' => 'products/default.webp',
                'description' => 'Wortel ungu kaya antioksidan',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Brokoli Hijau',
                'stock' => 12.5,
                'stok_kongsi' => 0,
                'cost_price' => 20000,
                'price' => 30000,
                'price_per_kg' => 30000,
                'sku' => 'SYR005',
                'barcode' => '1005',
                'image' => 'products/default.webp',
                'description' => 'Brokoli hijau segar dan bergizi',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Cabai Merah',
                'stock' => 0,
                'stok_kongsi' => 3.5,
                'cost_price' => 25000,
                'price' => 38000,
                'price_per_kg' => 38000,
                'sku' => 'SYR006',
                'barcode' => '1006',
                'image' => 'products/default.webp',
                'description' => 'Cabai merah segar pedas dan nikmat',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Bawang Bombay',
                'stock' => 22.0,
                'stok_kongsi' => 0,
                'cost_price' => 10000,
                'price' => 15000,
                'price_per_kg' => 15000,
                'sku' => 'SYR007',
                'barcode' => '1007',
                'image' => 'products/default.webp',
                'description' => 'Bawang bombay untuk segala masakan',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Labu Siam',
                'stock' => 0,
                'stok_kongsi' => 6.75,
                'cost_price' => 7000,
                'price' => 11000,
                'price_per_kg' => 11000,
                'sku' => 'SYR008',
                'barcode' => '1008',
                'image' => 'products/default.webp',
                'description' => 'Labu siam segar dan ringan',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Selada Hijau',
                'stock' => 10.25,
                'stok_kongsi' => 0,
                'cost_price' => 9000,
                'price' => 14000,
                'price_per_kg' => 14000,
                'sku' => 'SYR009',
                'barcode' => '1009',
                'image' => 'products/default.webp',
                'description' => 'Selada hijau untuk salad segar',
                'is_active' => true,
            ],
            [
                'category_id' => $kategorySayur->id,
                'name' => 'Kacang Panjang',
                'stock' => 0,
                'stok_kongsi' => 5.5,
                'cost_price' => 13000,
                'price' => 20000,
                'price_per_kg' => 20000,
                'sku' => 'SYR010',
                'barcode' => '1010',
                'image' => 'products/default.webp',
                'description' => 'Kacang panjang segar berkualitas',
                'is_active' => true,
            ],

            // BUAH-BUAHAN (10 produk) - Alternating antara stok regular dan stok kongsi
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Apel Malang',
                'stock' => 18.5,
                'stok_kongsi' => 0,
                'cost_price' => 25000,
                'price' => 35000,
                'price_per_kg' => 35000,
                'sku' => 'BUH001',
                'barcode' => '2001',
                'image' => 'products/default.webp',
                'description' => 'Apel malang manis dan segar',
                'is_active' => true,
                'discount_active' => true,
                'discount_percentage' => 10.00,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Jeruk Pontianak',
                'stock' => 0,
                'stok_kongsi' => 8.5,
                'cost_price' => 18000,
                'price' => 28000,
                'price_per_kg' => 28000,
                'sku' => 'BUH002',
                'barcode' => '2002',
                'image' => 'products/default.webp',
                'description' => 'Jeruk pontianak manis dan juicy',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Mangga Harum Manis',
                'stock' => 15.25,
                'stok_kongsi' => 0,
                'cost_price' => 22000,
                'price' => 32000,
                'price_per_kg' => 32000,
                'sku' => 'BUH003',
                'barcode' => '2003',
                'image' => 'products/default.webp',
                'description' => 'Mangga harum manis sempurna',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Pisang Cavendish',
                'stock' => 0,
                'stok_kongsi' => 12.0,
                'cost_price' => 8000,
                'price' => 12000,
                'price_per_kg' => 12000,
                'sku' => 'BUH004',
                'barcode' => '2004',
                'image' => 'products/default.webp',
                'description' => 'Pisang cavendish lembut dan manis',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Papaya Kuning',
                'stock' => 12.5,
                'stok_kongsi' => 0,
                'cost_price' => 10000,
                'price' => 15000,
                'price_per_kg' => 15000,
                'sku' => 'BUH005',
                'barcode' => '2005',
                'image' => 'products/default.webp',
                'description' => 'Papaya kuning manis dan berair',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Nanas Segar',
                'stock' => 0,
                'stok_kongsi' => 4.75,
                'cost_price' => 14000,
                'price' => 21000,
                'price_per_kg' => 21000,
                'sku' => 'BUH006',
                'barcode' => '2006',
                'image' => 'products/default.webp',
                'description' => 'Nanas segar manis dengan aroma wangi',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Strawberry Premium',
                'stock' => 8.0,
                'stok_kongsi' => 0,
                'cost_price' => 40000,
                'price' => 60000,
                'price_per_kg' => 60000,
                'sku' => 'BUH007',
                'barcode' => '2007',
                'image' => 'products/default.webp',
                'description' => 'Strawberry premium merah dan lembut',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Buah Naga Merah',
                'stock' => 0,
                'stok_kongsi' => 3.75,
                'cost_price' => 35000,
                'price' => 52000,
                'price_per_kg' => 52000,
                'sku' => 'BUH008',
                'barcode' => '2008',
                'image' => 'products/default.webp',
                'description' => 'Buah naga merah segar dan eksotis',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Anggur Hitam',
                'stock' => 7.25,
                'stok_kongsi' => 0,
                'cost_price' => 50000,
                'price' => 75000,
                'price_per_kg' => 75000,
                'sku' => 'BUH009',
                'barcode' => '2009',
                'image' => 'products/default.webp',
                'description' => 'Anggur hitam manis dan segar',
                'is_active' => true,
            ],
            [
                'category_id' => $kategoriBuah->id,
                'name' => 'Semangka Merah',
                'stock' => 0,
                'stok_kongsi' => 5.2,
                'cost_price' => 12000,
                'price' => 18000,
                'price_per_kg' => 18000,
                'sku' => 'BUH010',
                'barcode' => '2010',
                'image' => 'products/default.webp',
                'description' => 'Semangka merah segar dan berair',
                'is_active' => true,
            ],
        ];

        foreach ($products as $productData) {
            \App\Models\Product::create($productData);
        }

        $this->command->info('✅ Berhasil membuat 20 produk sayur dan buah!');
    }
}
